# 画面設計書 10-Config Scheduler Job

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のConfig Scheduler Job画面（Page ID: 9）の設計書である。Config Scheduler Job画面は、ユニットテストの定期実行（Cronjob）を設定・管理するためのモーダルダイアログ画面である。

### 本画面の処理概要

Config Scheduler Job画面は、QUASTOのユニットテストを定期的に自動実行するDBMS_SCHEDULERジョブの設定・管理を行う。スケジューラーの有効/無効切り替え、即時実行、実行履歴の確認が可能である。

**業務上の目的・背景**：継続的インテグレーション（CI）の一環として、データベースオブジェクトの品質チェックを定期的に実行することは重要である。本画面は、Oracleスケジューラーを使用してユニットテストを自動実行する機能を提供し、開発者の手動実行の負担を軽減しながら、定期的な品質監視を実現する。

**画面へのアクセス方法**：Dashboard画面から「Config Scheduler Job」ボタンをクリックしてモーダルダイアログとして開く。

**主要な操作・処理内容**：
1. Cronjobの有効/無効切り替え（Enable/Disable toggle）
2. Cronjobの即時実行（Run Cronjob Nowボタン）
3. スケジューラー情報の表示（First Start、Last Start、Next Run、Repeat Interval、Job State）
4. 実行履歴レポートの表示（Job History）
5. Closeボタンでダイアログを閉じて親画面に戻る

**画面遷移**：
- 遷移元：Dashboard画面（Config Scheduler Jobボタン）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | スケジューラージョブ管理 | 主機能 | Cronjobの有効/無効、即時実行、設定保存 |
| 31 | テスト実行履歴表示 | 副機能 | Job Historyレポートの表示 |

## 画面種別

モーダルダイアログ（設定・管理系）- 幅1500px

## URL/ルーティング

- Page ID: 9
- エイリアス: CONFIG-SCHEDULER-JOB
- URL例: `f?p=141:9:SESSION_ID`（ダイアログとして開くことを推奨）

## 入出力項目

### 入力項目（Buttons Container）

| 項目名 | 項目ID | タイプ | 説明 |
|--------|--------|--------|------|
| Enable schedule for Cronjob | P9_ENABLE_SCHEDULER_JOB | Yes/No | Cronjobの有効/無効設定 |

### 表示項目（Overview）

| 項目名 | 項目ID | タイプ | データソース | 説明 |
|--------|--------|--------|-------------|------|
| First Start | P9_START_DATE | 表示のみ | QA_JOB_DETAILS_P0009_V.START_DATE | 初回開始日時 |
| Last Start | P9_LAST_START_DATE | 表示のみ | QA_JOB_DETAILS_P0009_V.LAST_START_DATE | 最終実行日時 |
| Last Duration | P9_LAST_RUN_DURATION | 表示のみ | QA_JOB_DETAILS_P0009_V.LAST_RUN_DURATION | 最終実行時間 |
| Next Run | P9_NEXT_RUN_DATE | 表示のみ | QA_JOB_DETAILS_P0009_V.NEXT_RUN_DATE | 次回実行予定日時 |
| Repeat Interval | P9_REPEAT_INTERVAL | 表示のみ | QA_JOB_DETAILS_P0009_V.REPEAT_INTERVAL | 繰り返し間隔 |
| Job State | P9_JOB_STATE | 表示のみ | QA_JOB_DETAILS_P0009_V.STATE | ジョブ状態 |

### 隠し項目

| 項目名 | 項目ID | タイプ | ソース | 説明 |
|--------|--------|--------|-------|------|
| Cronjob Name | P9_CRONJOB_NAME | Hidden | PL/SQL Expression | スケジューラージョブ名 |

### Job History（折りたたみリージョン・展開状態）

| カラム名 | カラム別名 | 表示形式 | 説明 |
|---------|-----------|---------|------|
| Job Name | JOB_NAME | Hidden | ジョブ名（非表示） |
| Log Date | LOG_DATE | 日付（MM/DD/YYYY HH24:MI） | 実行日時 |
| Job Execution Status | STATUS | テキスト | 実行ステータス |
| Error Code | ERROR# | 数値（右寄せ） | エラーコード |
| Errors | ERRORS | テキスト | エラー詳細 |
| Run Duration | RUN_DURATION | テキスト | 実行時間 |

**レポート設定**:
- データソース: QA_JOB_RUN_DETAILS_P0009_V
- 表示行数: 5行
- ページネーション: 前へ/次へリンク
- データなしメッセージ: The Cronjob has not run recently.

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション | 条件 | スタイル |
|---------|--------|----------|----------|------|--------|
| Close | CLOSE | CLOSE | ダイアログを閉じる | なし | デフォルト |
| Save | SAVE | NEXT | 設定を保存 | なし | Hot + アイコン |
| Run Cronjob Now | RUN_CRONJOB_NOW | Overview内 | Cronjobを即時実行 | ジョブが実行中でない場合 | Hot + ストレッチ |
| Cronjob is running... | CRONJOB_IN_PROGRESS | Overview内 | なし（無効） | ジョブが実行中の場合 | Warning + 無効 |
| Refresh | REFRESH | Overview内 | ページをリフレッシュ | ジョブが実行中の場合 | Primary + Simple |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

### 2-Refresh Page

**トリガー**: REFRESHボタンクリック

**処理フロー**:
1. JavaScriptでページをリロード（location.reload()）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_JOB_DETAILS_P0009_V | SELECT | スケジューラージョブ情報を取得 |
| ページロード | QA_JOB_RUN_DETAILS_P0009_V | SELECT | 実行履歴を取得 |
| Save | USER_SCHEDULER_JOBS | DDL | Cronjobの有効/無効を切り替え |
| Run Cronjob Now | USER_SCHEDULER_JOBS | DDL | Cronjobを即時実行 |

### プロセス別詳細

#### Load information（Before Header）

**PL/SQLコード**:
```sql
begin
  select
    to_char(START_DATE, 'DD-MON-YYYY HH24:MI'),
    to_char(LAST_START_DATE, 'DD-MON-YYYY HH24:MI'),
    LAST_RUN_DURATION,
    to_char(NEXT_RUN_DATE, 'DD-MON-YYYY HH24:MI'),
    REPEAT_INTERVAL,
    STATE
  into
    :P9_START_DATE,
    :P9_LAST_START_DATE,
    :P9_LAST_RUN_DURATION,
    :P9_NEXT_RUN_DATE,
    :P9_REPEAT_INTERVAL,
    :P9_JOB_STATE
  from QA_JOB_DETAILS_P0009_V;
exception
  when no_data_found then
    :P9_START_DATE        := null;
    :P9_LAST_START_DATE   := null;
    :P9_LAST_RUN_DURATION := null;
    :P9_NEXT_RUN_DATE     := null;
    :P9_REPEAT_INTERVAL   := null;
    :P9_JOB_STATE         := null;
end;
```

#### Save Scheduler Job Status（SAVEボタン押下時）

**PL/SQLコード**:
```sql
qa_unit_tests_pkg.p_enable_scheduler_cronjob(pi_status => :P9_ENABLE_SCHEDULER_JOB);
```

**処理フロー**:
1. P9_ENABLE_SCHEDULER_JOBの値に応じてCronjobを有効/無効化
2. 'Y'の場合: dbms_scheduler.enable
3. 'N'の場合: dbms_scheduler.disable

#### Trigger Scheduler Cronjob（RUN_CRONJOB_NOWボタン押下時）

**PL/SQLコード**:
```sql
qa_unit_tests_pkg.p_trigger_scheduler_cronjob;
```

**処理フロー**:
1. ジョブが実行中でないことを確認
2. dbms_scheduler.run_jobで即時実行（use_current_session => false）

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 成功 | 保存成功時 | Saved. |
| - | 成功 | Cronjob開始時 | Cronjob started. |
| - | 情報 | 実行履歴なし | The Cronjob has not run recently. |
| - | 情報 | Job Historyの説明 | The following report shows the execution status of recent runs... |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| ジョブが存在しない | ページロード時にNULL値を設定 |
| ジョブが既に実行中 | 「Cronjob is running...」ボタンを表示、即時実行ボタンを非表示 |
| スケジューラーエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |

## 備考

- 本画面はモーダルダイアログとして表示（幅1500px）
- P9_ENABLE_SCHEDULER_JOBの初期値はqa_unit_tests_pkg.f_is_scheduler_cronjob_enabledから取得
- P9_CRONJOB_NAMEはqa_unit_tests_pkg.f_get_job_name(pi_is_cronjob => 'Y')から取得
- ジョブ実行中の判定はqa_unit_tests_pkg.f_is_job_runningを使用
- RUN_CRONJOB_NOWボタンとCRONJOB_IN_PROGRESSボタンは排他表示
- Job Historyリージョンはデフォルトで展開状態
- Info領域に出力に関する説明を表示（エラー表示のみで、無効オブジェクトの検出有無は表示されない）
- AutocompleteはセキュリティのためOFFに設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | モーダルダイアログ、レポート、ボタンの構成 |

**主要処理フロー**:
1. **行14-25**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定（幅1500px）
2. **行26-52**: Job Historyリージョン（折りたたみ・展開状態）の定義
3. **行38-52**: Infoリージョン（アラート）の定義
4. **行53-148**: History Reportレポートの定義
5. **行149-172**: Buttons Containerリージョンの定義
6. **行161-172**: Overviewリージョンの定義
7. **行173-251**: ボタン定義（RUN_CRONJOB_NOW、CRONJOB_IN_PROGRESS、REFRESH、CLOSE、SAVE）
8. **行252-370**: 表示項目定義（P9_CRONJOB_NAME、P9_*）
9. **行371-434**: プロセス定義（Save、Trigger、Load）

#### Step 2: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | スケジューラー関連関数・プロシージャ |

**主要処理フロー**:
- **行1304-1333**: `f_is_scheduler_cronjob_enabled`でCronjob有効状態を確認
- **行1335-1364**: `p_enable_scheduler_cronjob`でCronjobを有効/無効化
- **行1366-1386**: `p_trigger_scheduler_cronjob`でCronjobを即時実行
- **行1269-1302**: `f_is_job_running`でジョブ実行中かを確認
- **行1170-1220**: `f_get_job_name`でジョブ名を取得

### プログラム呼び出し階層図

```
Config Scheduler Job Page (Page 9)
    |
    +-- [Page Load - Before Header]
    |       |
    |       +-- P9_ENABLE_SCHEDULER_JOB Source
    |       |       |
    |       |       +-- qa_unit_tests_pkg.f_is_scheduler_cronjob_enabled
    |       |
    |       +-- P9_CRONJOB_NAME Source
    |       |       |
    |       |       +-- qa_unit_tests_pkg.f_get_job_name(pi_is_cronjob => 'Y')
    |       |
    |       +-- Process: Load information
    |               |
    |               +-- SELECT FROM QA_JOB_DETAILS_P0009_V
    |
    +-- [Button: SAVE - Submit]
    |       |
    |       +-- Process: Save Scheduler Job Status
    |               |
    |               +-- qa_unit_tests_pkg.p_enable_scheduler_cronjob
    |                       |
    |                       +-- dbms_scheduler.enable / disable
    |
    +-- [Button: RUN_CRONJOB_NOW - Submit]
    |       |
    |       +-- Condition: f_is_job_running = 'N'
    |       |
    |       +-- Process: Trigger Scheduler Cronjob
    |               |
    |               +-- qa_unit_tests_pkg.p_trigger_scheduler_cronjob
    |                       |
    |                       +-- dbms_scheduler.run_job
    |
    +-- [Button: REFRESH]
    |       |
    |       +-- Dynamic Action: location.reload()
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Dashboard画面               Page 9 Load                      Overview表示
                     ───>  Load information            ───> (P9_*項目)
                                 |
                                 v
                           QA_JOB_DETAILS_P0009_V
                           (USER_SCHEDULER_JOBSラッパー)

P9_ENABLE_                qa_unit_tests_pkg               USER_SCHEDULER_JOBS
SCHEDULER_JOB      ───>   .p_enable_scheduler_cronjob ───> (ENABLE/DISABLE)
(Y/N)

RUN_CRONJOB_NOW           qa_unit_tests_pkg               USER_SCHEDULER_JOBS
ボタン             ───>   .p_trigger_scheduler_cronjob ──> (RUN_JOB)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | Config Scheduler Job画面定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | スケジューラー管理関数・プロシージャ |
| page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ソース | Dashboard画面（呼び出し元） |
